Imports System
Imports System.IO
Imports System.Drawing

Public Class PICoscilo
    Dim WithEvents serialPort As New IO.Ports.SerialPort
    Public Delegate Sub myDelegate()
    Dim Cislo As Byte

    Dim Xko As Integer
    Dim Y(400) As Byte

    Private Sub PICoscilo_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Dim X As Integer

        btnConnect.Enabled = False
        btnDisconnect.Enabled = False

        For i As Integer = 0 To _
            My.Computer.Ports.SerialPortNames.Count - 1
            cbbCOMPorts.Items.Add(My.Computer.Ports.SerialPortNames(i))
        Next
        cbbSpeeds.Items.Add("9600")
        cbbSpeeds.Items.Add("19200")
        cbbSpeeds.Items.Add("38400")
        cbbSpeeds.Items.Add("57600")
        cbbSpeeds.Items.Add("115200")
        cbbSpeeds.SelectedIndex = 2
        For X = 0 To 400
            Y(X) = 0
        Next
        X = 0
    End Sub

    Private Sub cbbCOMPorts_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cbbCOMPorts.SelectedIndexChanged
        If Not btnDisconnect.Enabled Then btnConnect.Enabled = True
    End Sub

    Private Sub btnConnect_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnConnect.Click
        If serialPort.IsOpen Then
            serialPort.Close()
        End If

        Try
            With serialPort
                .PortName = cbbCOMPorts.Text
                .BaudRate = Val(cbbSpeeds.Text)
                .Parity = IO.Ports.Parity.None
                .DataBits = 8
                .StopBits = IO.Ports.StopBits.One
            End With
            serialPort.Open()
            btnConnect.Enabled = False
            btnDisconnect.Enabled = True
        Catch ex As Exception
            MsgBox(ex.ToString)
        End Try
    End Sub

    Private Sub btnDisconnect_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnDisconnect.Click

        Try
            serialPort.Close()
            btnConnect.Enabled = True
            btnDisconnect.Enabled = False
        Catch ex As Exception
            MsgBox(ex.ToString)
        End Try
    End Sub

    Private Sub serialPort_DataReceived(ByVal sender As Object, ByVal e As System.IO.Ports.SerialDataReceivedEventArgs) Handles serialPort.DataReceived
        If serialPort.BytesToRead <> 0 Then
            txtDataReceived.Invoke(New myDelegate(AddressOf updateData), New Object() {})
        End If
    End Sub

    Public Sub updateData()
        Cislo = serialPort.ReadByte
        txtDataReceived.Text = Cislo
        If Xko < 400 Then
            Xko = Xko + 1
        Else
            Xko = 0
        End If
        Y(Xko) = Cislo
        Me.Refresh()
    End Sub

    Private Sub PICoscilo_Paint(ByVal sender As Object, ByVal e As System.Windows.Forms.PaintEventArgs) Handles Me.Paint
        Dim X As Integer
        Dim p As New Pen(Color.GreenYellow, 3)
        Dim p1 As New Pen(Color.Red, 4)
        e.Graphics.Clear(Color.Black)
        For X = 0 To 399
            If X = Xko Then
                e.Graphics.DrawLine(p1, X, 350 - Y(X), X + 1, 350 - Y(X + 1))
            Else
                e.Graphics.DrawLine(p, X, 350 - Y(X), X + 1, 350 - Y(X + 1))
            End If
        Next
    End Sub
End Class
