;=============================================================================;
; ;
; Software License Agreement ;
; ;
; The software supplied herewith by Microchip Technology Incorporated ;
; (the "Company") for its dsPIC controller is intended and supplied to ;
; you, the Company's customer, for use solely and exclusively on ;
; Microchip dsPIC products. The software is owned by the Company and/or ;
; its supplier, and is protected under applicable copyright laws. All ;
; rights are reserved. Any use in violation of the foregoing ;
; restrictions may subject the user to criminal sanctions under ;
; applicable laws, as well as to civil liability for the breach of the ;
; terms and conditions of this license. ;
; ;
; THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES, ;
; WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED TO, ;
; IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR ;
; PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT, IN ANY ;
; CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR CONSEQUENTIAL ;
; DAMAGES, FOR ANY REASON WHATSOEVER. ;
; ;
;=============================================================================;
;
;	Pevzato ze strnek www.microchip.com 
;	Upravil Jakub erch
;
;	Pomoc asovae Timer1 blikme s diodou pipojenou
;		- na portu B6 pokud nen stisknut tlatko
;		- na portu B7 pokud je stisknut tlatko
;	Tlatko je pipojeno na port D0 (nem vnitn pull-up rezistor)
;
;	dky tkajc se hardwaru maj koment opaten temi hvzdikami ***, 
;	take je snadn je najt a pozmnit, pokud mte LEDky a tlatko pipojeny 
;	jinam ne v tomto pkladu.
;
;==============================================================================
	.equ __30F3012, 1
	.include "p30f3012.inc"
;------------------------------------------------------------------------------
;Globln deklarace
	.global __reset						;RESET - Label urujc zatek programu
	.global __OscillatorFail			;Interupt - Oscillator Fail
	.global __AddressError				;Interupt - Address Error trap
	.global __StackError				;Interupt - Stack Error trap
	.global __MathError					;Interupt - Math Error trap
;------------------------------------------------------------------------------
;Konfiguran bity (s bootloaderem jsou bezvznamn, protoe se pouv jeho
;														nastaven tchto bit)
config __FOSC, CSW_FSCM_OFF & XT_PLL8	;Osciltor krystal 8x PLL
config __FWDT, WDT_OFF					;Watchdog vypnut
config __FBORPOR, PBOR_OFF & BORV_27 & PWRT_16 & MCLR_EN
										;Brownout vypnut, povolen reset MCLR
config __FGS, CODE_PROT_OFF				;Ochrana kdu vypnut
;------------------------------------------------------------------------------
;Konstanty pouit v programu
	.equ FCY, #7372800*8/4				;Poet instrukc za sekundu 
										;FCY = frekvence x PLL / 4 
										;(dsPIC m 4  takty na jednu instrukci)
;==============================================================================
;Zatek kdu
	.text								;oznaen zatku sekce s programem
;------------------------------------------------------------------------------
;Inicializace zsobnku (ukazatel a omezova)
__reset: 	mov #__SP_init, W15 		;Inicializace ukazatele zsobnku
			mov #__SPLIM_init, W0 		;Adresa konce zsobnku
			mov W0, SPLIM 				;Uloen do registru limitu zsobnku
			nop 						;Instrukce nop, aby se SPLIM mohl inicializovat
;------------------------------------------------------------------------------
; *** Inicializace vstup na LED diody 
			mov #0x0000, W0 			;Budeme vypnat vstupy na danm portu
			mov W0, LATB				; *** LEDky jsou na portu B
			mov #0b0000000011000000, W0 ; *** Pslun piny (zde B6 a B7) 										
			mov W0, ADPCFG				;nastavme jako digitln (ne analogov)
			mov #0b1111111100111111, W0	; *** A budou to vstupy
			mov W0, TRISB				; *** nae LEDky jsou na portu B
			bset LATB, #6 				; *** Ob LEDky zapneme
			bset LATB, #7				; ***
;------------------------------------------------------------------------------
;Nastaven asovae Timer1 na 1/5 sekundovou periodu
			clr T1CON 					;Vypneme timer vynulovnm T1CON
			clr TMR1 					;Vynulujeme registr asovae
			mov #FCY/256/5,W0 			;Nastavme periodu na 1/5 sekundy
			mov W0, PR1 				;A nahrajeme do registru periody
			mov #0x8030,W0 				;Nakonfigurujeme Timer1 s peddlikou 1:256
			mov W0, T1CON 				;Nahrajeme do registru, m timer spustme
;------------------------------------------------------------------------------
;Hlavn nekonen smyka programu. ek se v n na to a asova nastav pznak T1IF.
;Po jeho nastaven se pekontroluje stav tlatka a podle nj se pepnou LED diody.
MainLoop: 	btss IFS0, #T1IF 			;Pesko nsledujc instrukci je-li nastaven pznak T1IF.
			bra MainLoop 				;Nebyl nastaven, sko zpt na MainLoop 
			bclr IFS0, #T1IF 			;Byl nastaven. Vynulovn pznaku.
			btss PORTD, #0 				; *** Test stavu tlatka (zde pipojeno k pinu D0) 
										;a podle toho peskok nsledujc instrukce.
			bra SwitchPressed			;Hodnota byla log 0 (tlatko stisknut). Skok na SwitchPressed 

;Tlatko nebylo stisknut (logick 1), pedchoz instrukce byla peskoena 
			btg LATB, #6 				; *** Pehozen stavu LED na portu B6
			bclr LATB, #7 				; *** Zhasnut LEDky na portu B7
			bra MainLoop 				;Skok zpt na zatek smyky

SwitchPressed:	;Tlatko bylo stisknut (logick 0)							
			bclr LATB, #6 				; *** Zhasnut LEDky na portu B6
			btg LATB, #7 				; *** Pehozen stavu LED na portu B7
			bra MainLoop 				;Skok zpt na zatek smyky
;==============================================================================
;Error traps (pasti na chyby)
;Procesory dsPIC jsou vybaveny nkolika peruenmi, ke kterm dojde pi nejzvanjch
;chybch procesoru. To pin monost programov eit i tyto kritick situace.
;Nsleduj jednoduch rutiny, kter v naem ppad pi tchto situacch pouze rozsvt 
;ob diody LED a sko do nekonenho syklu. 
;------------------------------------------------------------------------------
;Oscillator Fail - chyba osciltoru
	.text 								;oznaen zatku sekce s programem
__OscillatorFail:
			bset LATB, #6 				; *** Rozsvcen LED na portu B6
			bset LATB, #7 				; *** Rozsvcen LED na portu B7
			bra __OscillatorFail 		;Nekonen smyka
;------------------------------------------------------------------------------
;Address Error trap - chyba adresy
__AddressError:
			bset LATB, #6 				; *** Rozsvcen LED na portu B6
			bset LATB, #7 				; *** Rozsvcen LED na portu B7
			bra __AddressError 			;Nekonen smyka
;------------------------------------------------------------------------------
;Stack Error trap - chyba zsobnku
__StackError:
			bset LATB, #6 				; *** Rozsvcen LED na portu B6
			bset LATB, #7 				; *** Rozsvcen LED na portu B7
			bra __StackError 			;Nekonen smyka
;------------------------------------------------------------------------------
;Math (Arithmetic) - chyba pi vpotech
__MathError:
			bset LATB, #6 				; *** Rozsvcen LED na portu B6
			bset LATB, #7 				; *** Rozsvcen LED na portu B7
			bra __MathError 			;Nekonen smyka
;==============================================================================
	.end 
