/******************************************************************************
* Ukzka obsluhy A-D pevodnku
*
*   Hardware: pevd se signl ze vstupu AN2 (RB2)
*             vsledek se posl po sriovm portu do potae
******************************************************************************/
#include "p30F3012.h"
#include <stdlib.h>
//-----------------------------------------------------------------------------
//Konfiguran bity (s bootloaderem jsou bezvznamn, protoe se pouv jeho
//												vlastn nastaven tchto bit)
_FOSC(CSW_FSCM_OFF & XT_PLL8);	//Osciltor krystal 8x  PLL
_FWDT(WDT_OFF); 				//Watchdog vypnut
_FBORPOR(PBOR_OFF & BORV_27 & PWRT_16 & MCLR_EN); //Brownout vypnut, povolen reset MCLR
_FGS(CODE_PROT_OFF); 			//Ochrana kdu vypnuta
//-----------------------------------------------------------------------------
//Konstanty pouit v programu
#define FCY 7372800*8/4 	//Poet instrukc za sekundu 
								//FCY = frekvence x PLL / 4 
								//(dsPIC m 4  takty na jednu instrukci) 14,7456 MIPS - 67,817 ns na instrukci
#define baud 38400			// penosov rychlost UART
#define BRGH ((FCY/baud) / 16) - 1 // konstanta pro nastaven UART
//=============================================================================
//Hlavn program
int main(void)
{

	unsigned int Vzorek;
	LATB = 0x0000;  			// *** Vypneme LEDky
	TRISB = 0b1111111100111111; // *** Piny B6 a B7 nastavme jako vstupn
	T1CON = 0; 					//Vynulujeme konfiguran registr asovae
	TMR1 = 0; 					//Vynulujeme hodnotu asovae
	PR1 = FCY/256/2; 			//Nastavme periodu na 1/2 sekundy
	T1CON = 0x8030; 			//Zapneme asova Timer1 s peddliem 1:256

	LATBbits.LATB6 = 1;			//Rozsvcen LED1
	U1BRG=BRGH;					//nastaven dliky UARTu
	U1MODE=0x8000; 				//UART Enable, 8data, no parity, 1 stop
	U1STA =0x8400;				//enable TX 

// Nastaven A/D pevodnku

		PMD1bits.ADCMD = 0;		//!!!Zapnut napjen (vypn bootloader)
        //ADCON1 Registr
		ADCON1bits.ADON = 0;	//Vypnut pevodnku
        ADCON1bits.FORM = 0;	//formt vstupu (0 unsigned int, 1 int, 2 unsignet fractional, 3 fractional) 
        ADCON1bits.SSRC = 7;	//start pevodu (0 run, 1 INT0, 2 TMR3, 3 PWM, 7 auto)
        ADCON1bits.ASAM = 0;	//start samplovn (0 run, 1 auto ihned po pevodu)

        //ADCON2 Registr
        ADCON2bits.VCFG = 0;	//Referenn napt (0 ob z napjen, 1 +ext, 2 -ext, 3 ob z ext)
        ADCON2bits.CSCNA = 0;	//Scanovn vstup
        ADCON2bits.SMPI = 0;	//Poet pevod na interupt - 1
        ADCON2bits.BUFM = 0;	//Reim buffer (0 16, 1 2x8)
        ADCON2bits.ALTS = 0;	//Reim MUX (0 jen MUXA, 1 MUXA a MUXB)

        //ADCON3 Registr
		//Krystal 7,3728 MHz * 8/4 = 14,7456 MIPS => Tcy=67,8 ns
		//Pi Tad = 10 * Tcy bude Tad = 678 ns a minimln doba pevodu bude 15 * Tad = pibl. 9,4 us
		//a tedy minimln vzorkovac frekvence piblin 100 kHz 
        ADCON3bits.ADCS = 19; //ADCS = 2*Tad/Tcy - 1
		ADCON3bits.SAMC = 1;  //Poet Tad pro samplovn pi automatickm pevodu
		ADCON3bits.ADRC = 0;  //Volba hodin (O systmov, 1 RC osc.)

        //ADCHS Registr
        ADCHSbits.CH0NA = 0;  //Invert vstup CH0 (0 -Vref, 1 vstup AN1)
        ADCHSbits.CH0SA = 2;  //Neinvert vstup CH0 - vstup AN2	

        //ADCSSL Registr
        ADCSSL = 0; 	      //Scanovn se nepouv

        //ADPCFG Registr
        ADPCFG = 0xFFFF;      //Vechny vstupy digitln
        ADPCFGbits.PCFG2 = 0; //Jen AN2 jako analogov

        //Zapnut A/D pevodnku je dobr provdt a po dokonen konfigurace
        ADCON1bits.ADON = 1;

//Potebn nastaven je provedeno, meme jt na hlavn smyku programu

	while(1) 					//Nekonen cyklus
	{
		while(!IFS0bits.T1IF); 		//ekme na periodu asovae (cca 100 ms)
		IFS0bits.T1IF = 0; 			//Vymaeme pznak asovae
		ADCON1bits.SAMP = 1; 		//Zatek samplovn
		while(!ADCON1bits.DONE);	//ekme, a bude pevod hotov (pevod je automaticky zahjen po 1 Tad samplovn)
		Vzorek = ADCBUF0; 			//Uloen vzorku z bufferu
		U1TXREG = Vzorek >>8;		// Odeleme vy Byte
		U1TXREG = Vzorek;			// Odeleme ni Byte				
		LATBbits.LATB6 ^= 1; 		//Zmna stavu LED1 pi kadm pevodu
	}

} //Konec main()

