/******************************************************************************
* Ukzka obsluhy A-D pevodnku
*
*   Hardware: pevd se signl ze vstupu AN2 (RB2)
*             vsledek se posl po sriovm portu do potae
*   Software: zahjen pevodu je zeno asovaem TMR3
*			  vsledky se odeslaj v peruen od pevodnku			
******************************************************************************/
#include "p30F3012.h"
#include <stdlib.h>
//-----------------------------------------------------------------------------
//Konfiguran bity (s bootloaderem jsou bezvznamn, protoe se pouv jeho
//												vlastn nastaven tchto bit)
_FOSC(CSW_FSCM_OFF & XT_PLL8);	//Osciltor krystal 8x  PLL
_FWDT(WDT_OFF); 				//Watchdog vypnut
_FBORPOR(PBOR_OFF & BORV_27 & PWRT_16 & MCLR_EN); //Brownout vypnut, povolen reset MCLR
_FGS(CODE_PROT_OFF); 			//Ochrana kdu vypnuta
//-----------------------------------------------------------------------------
//Konstanty pouit v programu
#define FCY 7372800*8/4 			// Poet instrukc za sekundu 
									// FCY = frekvence x PLL / 4 
									// (dsPIC m 4  takty na jednu instrukci) 14,7456 MIPS - 67,817 ns na instrukci
#define baud 38400					// penosov rychlost UART
#define BRGH ((FCY/baud) / 16) - 1 	// konstanta pro nastaven UART

#define Fsamp 10					// Vzorkovac frekvence A/D pevodnku 10 Hz
#define T3period FCY/64/Fsamp 		// vpoet konstanty pro TMR3 (pi peddlice 1/64)
//-----------------------------------------------------------------------------
// Funkce s globln psobnost

//_ADCInterrupt() je funkce volan pi peruen od A/D pevodnku (tzv. Interupt Service Routine ISR).
//Aby funkce fungovala jako ISR, mus mt globln psobnost
//Nzev funkce mus pesn odpovdat nzvu podle linker scriptu (soubor *.gld), aby j linker sprvn piadil
//k peruen od pevodnku  
void __attribute__((interrupt, no_auto_psv)) _ADCInterrupt(void)
{
		unsigned int Vzorek;
        IFS0bits.T3IF = 0; 	//Vynulujeme pznak peruen od timeru 3 (kter pedtm spustil A/D pevod)
        IFS0bits.ADIF = 0;	//Vynulujeme pznak peruen od A/D pevodnku (kter spustil toto peruen)
		//Provedeme vlastn obsluhu peruen 
		//(V tomto ppad jen jednoduch odesln vsledk sriovm portem a pepnut LEDky)
		Vzorek = ADCBUF0; 			//Uloen vzorku z bufferu
		U1TXREG = Vzorek >>8;		// Odeleme vy Byte
		U1TXREG = Vzorek;			// Odeleme ni Byte
		// U1TXREG = Vzorek >>4;	// Pokud chceme odeslat jen jednu 8 bitovou hodnotu, pedchoz dva dky nahradme tmto 					
		LATBbits.LATB6 ^= 1; 		//Zmna stavu LED1 pi kadm pevodu (abychom vidli, e program funguje)

}
// Ve funkci Inicializace se provd veker potebn nastaven. Funkce je napsna s ohledem na dobrou itelnost programu.
// Pi praktickm pouit by se dala vrazn optimalizovat, m by se uetila pam i doba potebn pro jej vykonn
void Inicializace(void)
{
	// Nastaven vstup/vstup
	LATB = 0x0000;  			// *** Vypneme LEDky
	TRISB = 0b1111111100111111; // *** Piny B6 a B7 nastavme jako vstupn
	
	//Nastaven asovae TMR3
	T3CON = 0; 					// Vynulujeme konfiguran registr asovae
	T3CONbits.TCKPS = 2;		// Nastaven peddlie (0 - 1/1, 1 - 1/8, 2 - 1/64, 3 - 1/256)
    TMR3 = 0;					// Vynulujeme vlastn asova
    PR3 = T3period;				// Nastavme periodu
    IFS0bits.T3IF = 0;			// Vynulujeme pznak peruen
    IEC0bits.T3IE = 0;			// Zakeme peruen od asovae

	LATBbits.LATB6 = 1;			//Rozsvcen LED1
	U1BRG=BRGH;					//nastaven dliky UARTu
	U1MODE=0x8000; 				//UART Enable, 8data, no parity, 1 stop
	U1STA =0x8400;				//enable TX 

// Nastaven A/D pevodnku

		PMD1bits.ADCMD = 0;		//!!!Zapnut napjen (vypn bootloader)
        //ADCON1 Registr
		ADCON1bits.ADON = 0;	//Vypnut pevodnku
        ADCON1bits.FORM = 0;	//formt vstupu (0 unsigned int, 1 int, 2 unsignet fractional, 3 fractional) 
        ADCON1bits.SSRC = 2;	//start pevodu (0 run, 1 INT0, 2 TMR3, 3 PWM, 7 auto)
        ADCON1bits.ASAM = 1;	//start samplovn (0 run, 1 auto ihned po pevodu)

        //ADCON2 Registr
        ADCON2bits.VCFG = 0;	//Referenn napt (0 ob z napjen, 1 +ext, 2 -ext, 3 ob z ext)
        ADCON2bits.CSCNA = 0;	//Scanovn vstup
        ADCON2bits.SMPI = 0;	//Poet pevod na interupt - 1
        ADCON2bits.BUFM = 0;	//Reim buffer (0 16, 1 2x8)
        ADCON2bits.ALTS = 0;	//Reim MUX (0 jen MUXA, 1 MUXA a MUXB)

        //ADCON3 Registr
		//Krystal 7,3728 MHz * 8/4 = 14,7456 MIPS => Tcy=67,8 ns
		//Pi Tad = 32 * Tcy bude Tad = pibl. 2,17 us a minimln doba pevodu bude 14 * Tad = pibl. 30 us
		
        ADCON3bits.ADCS = 63; //ADCS = 2*Tad/Tcy - 1
		ADCON3bits.SAMC = 0;  //Poet Tad pro samplovn pi automatickm pevodu
		ADCON3bits.ADRC = 0;  //Volba hodin (O systmov, 1 RC osc.)

        //ADCHS Registr
        ADCHSbits.CH0NA = 0;  //Invert vstup CH0 (0 -Vref, 1 vstup AN1)
        ADCHSbits.CH0SA = 2;  //Neinvert vstup CH0 - vstup AN2	

        //ADCSSL Registr
        ADCSSL = 0; 	      //Scanovn se nepouv

        //ADPCFG Registr
        ADPCFG = 0xFFFF;      //Vechny vstupy digitln
        ADPCFGbits.PCFG2 = 0; //Jen AN2 jako analogov
		
		//Sputn pevodnku
        IFS0bits.ADIF = 0;    // Vynulovn IF od A/D pevodnku
        IEC0bits.ADIE = 1;	  // Povolen interuptu od A/D pevodnku
        ADCON1bits.ADON = 1;  // Zapnut A/D pevodnku
		T3CONbits.TON = 1;	  // Zapnut asovae
} //Konec Inicializace()

//=============================================================================
//Hlavn program
int main(void)
{
	Inicializace();				// Ve se nejprve zinicializuje
	while(1) 					// Nekonen cyklus
	{
	//veker obsluha se realizuje jen v ISR, proto je zde hlavn smyka programu przdn 
	}

} //Konec main()

